# Add conditional and ...
# ... disable by default, mostly for older distros.
%global want_python3 0
%if 0%{?suse_version} > 1310 || 0%{?fedora} >= 26 || 0%{?rhel} >= 8
# ... enable by default on newer distros.
%global want_python3 1
%endif

# Fedora 30 deprecated Python 2, 31 disabled support for building these
# packages.
# OpenSuSE Leap 15.4 seems to have dropped it, too, and it's certainly dead
# for Tumbleweed and ALP.
%global want_python2 1
%if 0%{?fedora} >= 31 || 0%{?suse_version} >= 1600 || 0%{?sle_version} >= 150400
%global want_python2 0
%endif

# Prefer Python 3 if both variants have been requested.
%if 0%{?want_python2} && 0%{?want_python3}
%global want_python2 0
%endif

# Conditional builds are a bit weird.
# You CAN either enable or disable a feature via %%bcond_with{,out}, BUT you
# can NOT override this value later on, it seems.
# Case in point: I tried to use %%bcond_without python2 for all older Fedora
# versions, %%bcond_with python3 for all Fedora versions starting with 26.
# However, as pyhoca-{gui,cli} are just applications, we want to build against
# one specific python version only, so I later tried to override the Python-2-
# build via %%bcond_with python2, essentially disabling it and preferring the
# Python-3-based version.
# This didn't work, since %%{?with_python2} was kept enabled.
# Hence, we'll only enable/disable a feature once now, based upon the global
# macros.
%if 0%{?want_python2}
%bcond_without  python2
%else
%bcond_with     python2
%endif
%if 0%{?want_python3}
%bcond_without  python3
%else
%bcond_with     python3
%endif

# Provide a default implementation, essentially for non-*SuSE platforms.
%if 0%{?with_python3}
%if ( ! ( 0%{?rhel} ) )
%global name_helper_python3 python3
%if 0%{?with_python2}
%global name_helper_python2 python2
%{?!python_module:%global python_module() python-%{**} python3-%{**}}
%else
%global name_helper_python2 %{nil}
%{?!python_module:%global python_module() python3-%{**}}
%endif
%else
%if 0%{?rhel} >= 7
%global name_helper_python3 python%{python3_pkgversion}
%if 0%{?with_python2}
%global name_helper_python2 python2
%{?!python_module:%global python_module() python-%{**} python%{python3_pkgversion}-%{**}}
%else
%global name_helper_python2 %{nil}
%{?!python_module:%global python_module() python%{python3_pkgversion}-%{**}}
%endif
%else
%global name_helper_python3 python34
%if 0%{?with_python2}
%global name_helper_python2 python
%{?!python_module:%global python_module() python-%{**} python34-%{**}}
%else
%global name_helper_python2 %{nil}
%{?!python_module:%global python_module() python34-%{**}}
%endif
%endif
%endif
%else
%global name_helper_python3 %{nil}
%if 0%{?with_python2}
%global name_helper_python2 python
%{?!python_module:%global python_module() python-%{**}}
%else
%global name_helper_python2 %{nil}
%{?!python_module:%global python_module()}
%endif
%endif

%if ! 0%{?with_python3}
%global         skip_python3 1
%endif

%if ! 0%{?with_python2}
%global         skip_python2 1
%endif

# Workaround for OpenSuSE Leap 42.3. This is the first version to introduce
# the macros, but in a broken state. It will generate pythonX dependencies
# if pythonX has been installed in the build environment and not honor
# skip_pythonX.
# Override to the expected behavior.
%if 0%{?sle_version} && 0%{?sle_version} == 120300 && 0%{?is_opensuse}
%if 0%{?with_python3}
%if 0%{?with_python2}
%global python_module() python-%{**} python3-%{**}
%else
%global python_module() python3-%{**}
%endif
%else
%if 0%{?with_python2}
%global python_module() python-%{**}
%else
%global python_module()
%endif
%endif
%endif

Name:           pyhoca-cli
Version:        0.6.1.3
Release:        0.0x2go1%{?dist}
Summary:        Command line X2Go client written in Python

Group:          Applications/Communications
%if 0%{?suse_version}
License:        AGPL-3.0+
%else
License:        AGPLv3+
%endif
URL:            https://www.x2go.org/
Source0:        https://code.x2go.org/releases/source/%{name}/%{name}-%{version}.tar.gz

BuildArch:      noarch
%if 0%{?with_python2}
%if 0%{?sle_version} && ( ( 0%{?sle_version} < 120300 && 0%{?is_opensuse} ) || ( ! 0%{?is_opensuse} ) )
# On some *SuSE versions, we still need python-devel, even though we also enable Python 3
# builds there and consequently should build-depend upon python2-devel... but it doesn't
# exist there.
BuildRequires:  python-devel
%else
BuildRequires:  %{name_helper_python2}-devel
%endif
BuildRequires:  python-setuptools
Requires:       python-setproctitle
Requires:       %{name_helper_python2}-x2go >= 0.6.1.0
%endif
%if 0%{?with_python3}
BuildRequires:  %{name_helper_python3}-devel
BuildRequires:  %{name_helper_python3}-setuptools
Requires:       %{name_helper_python3}-setproctitle
Requires:       %{name_helper_python3}-x2go >= 0.6.1.0
%endif
%if 0%{?suse_version}
BuildRequires:  fdupes
%if ( 0%{?sle_version} && 0%{?sle_version} >= 120300 && 0%{?is_opensuse} ) || ( 0%{?suse_version} > 1500 )
BuildRequires:  python-rpm-macros
%endif
%endif

BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
X2Go is a server based computing environment with:
   - session resuming
   - low bandwidth support
   - LDAP support
   - client side mass storage mounting support
   - client side printing support
   - audio support
   - authentication by smartcard and USB stick

PyHoca-CLI provides a simple and flexible command line client
written in Python that allows you to control X2Go client sessions
on desktops and thin clients.


%prep
%setup -q
%if 0%{?with_python2}
sed -i -e '1s@^#/usr/bin/python3@/usr/bin/%{name_helper_python2}@' '%{name}'
%endif
%if 0%{?with_python3}
sed -i -e '1s@^#/usr/bin/python3@/usr/bin/%{name_helper_python3}@' '%{name}'
%endif


%build
%if 0%{?with_python2}
%if 0%{?suse_version}
%if 0%{?sle_version} && ( ( 0%{?sle_version} < 120300 && 0%{?is_opensuse} ) || ( ! 0%{?is_opensuse} ) )
python2 setup.py build
%else
%{python2_build}
%endif
%else
%{py2_build}
%endif
%endif
%if 0%{?with_python3}
%if 0%{?suse_version}
%if 0%{?sle_version} && ( ( 0%{?sle_version} < 120300 && 0%{?is_opensuse} ) || ( ! 0%{?is_opensuse} ) )
python3 setup.py build
%else
%{python3_build}
%endif
%else
%{py3_build}
%endif
%endif

%install
%if 0%{?with_python2}
%if 0%{?suse_version}
%if 0%{?sle_version} && ( ( 0%{?sle_version} < 120300 && 0%{?is_opensuse} ) || ( ! 0%{?is_opensuse} ) )
python2 setup.py install --skip-build --root %{buildroot}
%else
%{python2_install} --skip-build
%endif
%else
%{py2_install}
%endif
%endif
%if 0%{?with_python3}
%if 0%{?suse_version}
%if 0%{?sle_version} && ( ( 0%{?sle_version} < 120300 && 0%{?is_opensuse} ) || ( ! 0%{?is_opensuse} ) )
python3 setup.py install -O1 --skip-build --prefix %{_prefix} --root %{buildroot}
%else
%{python3_install} -O1 --skip-build
%endif
%else
%{py3_install}
%endif
%endif
mkdir -p %{buildroot}/%{_bindir}/
cp -p %{name} %{buildroot}/%{_bindir}/
mkdir -p %{buildroot}/%{_mandir}/
cp -rp man/* %{buildroot}/%{_mandir}/
%if 0%{?fdupes:1}
%fdupes %buildroot/%_prefix
%endif


%files
%defattr(-,root,root)
%doc COPYING README TODO
%{_bindir}/%{name}
%if 0%{?with_python2}
%if 0%{?suse_version}
%if ( 0%{?sle_version} && 0%{?sle_version} >= 120300 && 0%{?is_opensuse} ) || ( 0%{?suse_version} > 1500 )
%{python2_sitelib}/pyhoca/
%{python2_sitelib}/PyHoca_CLI*
%else
%{python_sitelib}/pyhoca/
%{python_sitelib}/PyHoca_CLI*
%endif
%else
%{python2_sitelib}/pyhoca/
%{python2_sitelib}/PyHoca_CLI*
%endif
%endif
%if 0%{?with_python3}
%{python3_sitelib}/pyhoca/
%{python3_sitelib}/PyHoca_CLI*
%endif
%{_mandir}/man1/%{name}.1*


%changelog
