#!/bin/bash
# Makes sure every key in ${project}-{maintainers,keyring}-gpg has an entry in the
# index mapping file.
set -e

typeset -i fail='0'

for keyring in 'x2go-maintainers' 'x2go-maintainers-removed-keys' 'active-keys' 'removed-keys'; do
  pushd "${keyring}" >'/dev/null'
  while read -r -d '' key; do
    key="${key#./}"
    if ! grep -Eq "  ${key}\$" 'index'; then
      echo "${keyring}: ${key} is not in index file."
      fail='1'
    fi
  done < <(find . -iname 'add-*' -print0)
  popd >'/dev/null'
done

exit "${fail}"
