#!/bin/bash
# Looks for expired keys in our active keyrings
set -e

find_expired () {
	k="${1}"
	gpg --no-options --no-auto-check-trustdb --no-default-keyring \
		--keyring "keyrings/${k}" --list-keys --with-colons \
		| grep '^pub' \
		| awk -F':' -v keyring="${1}" \
		'$2 == "e" {print keyring ":\t0x" $5 " expired on " $7}'
}

typeset -i fail='0'
for keyring in 'x2go-maintainers-keyring.gpg' 'x2go-archive-keyring.gpg'; do
	find_expired "${keyring}"
done

exit "${fail}"
